﻿/*	VERSION: 	0.1

USAGE: 
	#include "functions/dragDrop.as"
	
	DRAGDROP.enable( self, "import" );		// import export both
	
	// input		(drop is occuring)
	react.to( "import" ).then = function( evt ){
		// ignore import from self
		// do stuff with imported evt.value
		
		// announce that the value was accepted and the drop succeeded
		evt.dataAccepted();		// this fires "exportAccepted" within the originating object
	}// import()
	
	
	// output		(dragging starts)
	react.to( "export" ).then = function( evt ){
		if( evt.data )						return;		// ignore if:  Export data has already been created
		
		// create export data
		evt.data = "drop this value";
	}// export()
	
	
	// drop was accepted by something else
	react.to( "exportAccepted" ).then = function( evt ){
		if( evt.from !== self )		return;		// ignore if:  Not from self
		
		// do stuff after successful export
	}// exportAccepted()
	
*/
function runFunc( func ){
	var _this = _this || this;
	return func.apply( _this, arguments.slice() );
}// runFunc()



function once( func ){
	var done = false;
	return function () {
		return done ? void 0 : ((done = true), func.apply(this, arguments));
	}
}// once()



runFunc( function(){
	var selfName = "DRAGDROP";
	// abort if:  already exists
	if( _global[ selfName ] )		return;
	
	#include "detectRemoval.as"
	#include "eventSystem3.as"
	#include "hitClip.as"
	
	// create global interface
	var _this = _global[ selfName ] = {};
	_this.enable = addClip;
	_this.disable = removeClip;
	
	// enable events
	AsBroadcaster.initialize( _this );
	var react = make_react( _this );
	
	// Items that can be dragged
	var dragTargets = [];
	// Items that can receive drops
	var dropTargets = [];
	
	// drag tracking variables
	var mouseIsHeld = false;
	var dragObject = {}
	var reactToSourceUnload = undefined;
	
	
	
	function isHovering( itemList, ignoreThis ){
		for(var i=0; i<itemList.length; i++){
			if( ignoreThis  &&  itemList[ i ] === ignoreThis )		continue;		// Optionally ignore a movieClip
			if(  hitClip( {x:_root._xmouse,y:_root._ymouse}, itemList[ i ] )  )		return itemList[ i ];
		}// for each:  itemList
		return undefined;
	}// isHovering()
	
	
	
	// start dragging  +  "export" event
	react.to("onMouseDown").from(Mouse).then = function(){
		trace("onMouseDown");
		if( mouseIsHeld === true )		return;		// if:  A drag is already occurring,  then:  do nothing
		
		// Detect whether a dragTarget is being clicked
		var dragFrom = isHovering( dragTargets );
		if( !dragFrom )		return;							// nothing relevent was clicked
		
		// setTimeout(function(){
		// create a new event object for export and import
		dragObject = {
			from:	dragFrom, 
			to:		undefined, 
			data:	undefined
		}
		// Tell this movieClip to create data for export.  If anything reacts, it's supposed to directly populate dragObject.data
		trace("  Sending 'export' event to:  " + dragFrom._name);
		sendEvent("export", dragObject, dragFrom);
		
		// check whether the "export" event generated data.
		var allowDrag = Boolean( dragObject.data !== undefined );
		
		trace("  allowDrag: " + allowDrag);
		trace("  dragObject.data: " + dragObject.data);
		if( allowDrag )
		{// if:  The "export" event generated data to export
			// Display a "drag" cursor  (using Zinc)
			mdm.Input.Mouse.setCursor( "Drag" );
			// If the source movieClip vanishes during the drag,  abort the drag
			reactToSourceUnload = react.once().to("unload").from( dragFrom ).then = stopDragging;
			// Allow dropping stuff
			mouseIsHeld = true;
		}// if:  The "export" event generated data to export
		else
		{// if:  The "export" event did NOT generate data
			stopDragging();
		}// if:  The "export" event did NOT generate data
		// }, 0);
	}// onMouseDown()
	
	
	
	// end dragging  +  "import" event
	react.to("onMouseUp").from(Mouse).then = function(){
		trace("onMouseUp");
		if( mouseIsHeld === false )		return stopDragging();		// if:  dragging was cancelled,  then:  do nothing
		
		// disable dropping stuff
		mouseIsHeld = false;
		// Change the cursor back to normal  (using Zinc)
		mdm.Input.Mouse.setCursor( "Default" );
		
		// detect whether a dropTarget is being hovered
		var dropHere = isHovering( dropTargets, dragObject.from );
		if( !dropHere )		return stopDragging();												// Not dropped on nothing relevent  =>  do nothing
		if( dropHere === dragObject.from )		return stopDragging();		// Dropped on drag-source  =>  do nothing		(Don't let movieClips drop things on themselves)
		
		// In case the drag-source wants to directly access the drop-target  (Probably not wise)
		dragObject.to = dropHere;
		
		// Tell the drag-source that the export succeeded
		var successfulDragObject = dragObject;
		dragObject.dataAccepted = function(){
			trace("dragObject.dataAccepted() was called");
			trace("  Sending 'exportAccepted' event to:  " + successfulDragObject.from._name);
			sendEvent("exportAccepted", successfulDragObject, successfulDragObject.from);
			delete successfulDragObject.dataAccepted;		// Can only be called once  +  No need to store this
			successfulDragObject = undefined;						// No need to store this
		}// dataAccepted()
		dragObject.dataAccepted = once( dragObject.dataAccepted );		// can only be called once
		
		// Tell this movieClip to receive data
		trace("  Sending 'import' event to:  " + dropHere._name);
		sendEvent("import", dragObject, dropHere);
		
		// stop dragging
		stopDragging();
	}// onMouseUp()
	
	
	
	function stopDragging(){
		trace("stopDragging()");
		mouseIsHeld = false;
		dragObject = {};
		reactToSourceUnload = undefined;
	}// stopDragging()
	
	
	
	function addClip( newClip, permissions ){
		if( !newClip )		return;		// no movieClip  =>  do nothing
		
		// auto populate "permissions" is missing or invalid
		if(	permissions !== "import"
		&&	permissions !== "export"
		&&	permissions !== "both")		permissions = "both";
		
		// export
		if( permissions === "export"  ||  permissions === "both" ){
			addItem( newClip, dragTargets );
		}// if:  This movieClip is allowed to export data
		
		// import
		if( permissions === "import"  ||  permissions === "both" ){
			addItem( newClip, dropTargets );
		}// if:  This movieClip is allowed to import data
	}// addClip()
	
	
	function removeClip( removeThisClip ){
		if( !removeThisClip )		return;		// no movieClip  =>  do nothing
		removeItem( removeThisClip, dragTargets );
		removeItem( removeThisClip, dropTargets );
	}// removeClip()
	
	
	
	function addItem( addThis, toThis ){
		if( !addThis )		return;
		if( !toThis )			return;
		if(  getIndex( addThis, toThis ) === undefined  ){
			toThis.push( addThis );
		}// if:   this item is not already in this list
	}// addItem()
	
	
	
	function removeItem( removeThis, fromThis ){
		if( !removeThis )		return;
		if( !fromThis )			return;
		// remove all instances of this movieClip
		for(var i=fromThis.length-1; i>=0; i--){
			// remove each match you find
			if( fromThis[ i ] === removeThis )		fromThis.splice( i, 1 );
		}// for each:  item in the "fromThis" array  (looking backwards)
	}// removeItem()
	
	
	
	function getIndex( findThis, inThis ){
		if( !findThis )		return undefined;
		if( !inThis )			return undefined;
		for(var i=0; i<inThis.length; i++){
			if( inThis[ i ] === findThis )		return i;
		}
		return undefined;
	}// hasItem()
	
	
	
	// destructor
	react.to("unload").then = function(){
		stopDragging();
	}// unload()
	// Enable the destructor.  Detect when DRAGDROP is no longer global.
	detectRemoval( _global, selfName, function(){
		sendEvent( "unload", null, _this );
	});// detectRemoval()
});// runFunc()